<?php
  BEvent::HookInstanceOf('BioSidebar', 'Generate', 'sidebars: generate: bio');

/* one-shot */
  $this->name = 'bio sidebar';
  $this->Caption('Боковая панель с моей информацией', 'ru');
/* install CommentsSidebar */
class BioSidebar extends BaseSidebar {
  static $iconByValue = array('sex' => 1, 'country' => 1);
  static $allowedBareIcons = array('my' => 1);
  static $linkGroups = array('projects' => 1, 'contact' => 1, 'chat' => 1, 'social' => 1);

  static $dataUriByExt = array('png' => 'data:image/png;base64,',
                               'gif' => 'data:image/gif;base64,');

  public $type = 'bio';
  public $hasExtConfig = true;

  public $dataUriIcons = array('png' => 1, 'gif' => 1);
  public $maxSizeForDataURI = 3072;   // 3 KiB.

  function DoGenerate() {
    $bio = array();

    foreach ($this->config as $key => $value) {
      $key = strtolower($key);
      $value = trim($value);

      if ($key === 'data uri icons') {
        $this->dataUriIcons = array_flip(explode(' ', $value));

        foreach ($this->dataUriIcons as $item => $value) {
          is_numeric($item) and $this->maxSizeForDataURI = $item;
        }
      } elseif ($value !== '') {
        @list($group, $key) = explode(' ', $key, 2);

        if (($key = trim($key)) !== '' and $key !== 'show') {
          $thisGroup = &$bio[$group];
          isset($thisGroup) or $thisGroup = array();

          $thisGroup[$key] = $this->MakeValueFrom($group, $key, $value);
        } else {
          if ($group === 'bio') {
            // bypass.
          } elseif ($group === 'photos') {
            $value = $this->ParsePhotos($value);
          } else {
            $value = null;
          }

          $value and $bio[$group] = $value;
        }
      }
    }

    return $bio;
  }

    function MakeValueFrom($group, $key, $value) {
      $label = &BConfig::$strings["bio $group: $key"];
      $label or $label = &BConfig::$strings["bio $key"];

      if (!empty(self::$allowedBareIcons[$group]) and $key !== 'gmt') {
        $ch = mb_substr($value, 0, 1);
        $iconMode = $ch === '-' ? 'hide' : ($ch === '+' ? 'only' : 'show');
        $iconMode === 'show' or $value = mb_substr($value, 1);
      } else {
        $iconMode = 'show';
      }

      $icon = null;

        if ($iconMode !== 'hide') {
          if (!empty(self::$iconByValue[$key])) {
            $lower = strtolower($value);
            $key === 'country' and $lower = substr($lower, 0, 2);

            $icon or $icon = FindImage(BConfig::FileOf('static', "bio/$key-$lower"));
            $icon or $icon = FindImage(BConfig::FileOf('static', "bio/$lower"));
          }

          $icon or $icon = FindImage(BConfig::FileOf('static', "bio/$group-$key"));
          $icon or $icon = FindImage(BConfig::FileOf('static', "bio/$key"));
          $icon or $icon = FindImage(BConfig::FileOf('static', "bio/$group"));

          $icon and $icon = $this->EncodeIcon( 'bio/'.basename($icon) );
        }

      switch ($key) {
      case 'gmt':       $value = strtr($value, ',', '.'); break;
      case 'birthday':  $value = strtotime($value); break;
      }

      if (!empty(self::$linkGroups[$group])) {
        $links = array();

          foreach (explode("\n", $value) as $piece) {
            if (($piece = trim($piece)) !== '') {
              $url = strtok($piece, ' ');
              if (strpbrk($url, ':@') !== false) {
                $piece = strtok(null);
              } else {
                $url = null;
              }

              if ($url and $key === 'email' and strrchr($url, '@') !== false and
                  substr($url, 0, 7) !== 'mailto:') {
                $url = "mailto:$url";
              }

              $links[] = array('link' => $url, 'caption' => trim($piece));
            }
          }

        $value = $links;
      }

      $iconMode === 'only' and $value = '';
      return compact('label', 'icon', 'value');
    }

      function EncodeIcon($path) {
        $ext = ltrim(ExtOf($path), '.');
        $file = BConfig::FileOf('static', $path);

        if (isset($this->dataUriIcons[$ext]) and $prefix = &self::$dataUriByExt[$ext]
            and filesize($file) <= $this->maxSizeForDataURI) {
          return $prefix.base64_encode( file_get_contents($file) );
        } else {
          return BConfig::$staticURL.$path;
        }
      }

    function ParsePhotos($str) {
      $res = array();
      $i = 0;

        $imageRoot = BConfig::$paths['static'].'bio/';
        $isRandom = $breakBefore = false;

        foreach (explode("\n", $str) as $piece) {
          $item = null;

            if (($piece = trim($piece)) !== '') {
              if (ltrim($piece, '-') === '') {
                $breakBefore = true;
              } else {
                if ($piece[0] === '?') {
                  $isRandom or ++$i;
                  $isRandom = true;

                  $piece = ltrim(substr($piece, 1));
                } else {
                  $isRandom = false;
                  ++$i;
                }

                @list($image, $title) = explode(' ', $piece, 2);

                $link = strtok($title, ' ');
                if ($link === '-' or $link[0] === '/' or strpos($link, '://')) {
                  $title = strtok(null);
                } else {
                  $link = null;
                }

                $file = ToAbsolutePath($image, $imageRoot);
                $file = FindImage($file);

                if ($file) {
                  if (IsRelativePath($image)) {
                    $image = BConfig::$staticURL.'bio/'.substr($file, strlen($imageRoot));
                  }

                  $link or $link = $image;
                  $link === '-' and $link = null;

                  $item = compact('image', 'link', 'title', 'breakBefore');
                  $breakBefore = false;
                }
              }
            }

          $item and $res[$i][] = $item;
        }

      foreach ($res as &$photo) {
        $photo = count($photo) > 1 ? $photo[ array_rand($photo) ] : $photo[0];
      }

      return $res;
    }

  function ParseConfig(&$str) {
    @list($str, $isHTML, $bio) = preg_split('/^ *==+ *bio((?: +html)?) *==+ *$/mu',
                                             $str, 2, PREG_SPLIT_DELIM_CAPTURE);

    if (isset($bio)) {
      $isHTML or $bio = BUverseWiki::ToHTML($bio);
    } else {
      $bio = '';
    }

    return compact('bio') + parent::ParseConfig($str);
  }
}

/* one-shot */
return;
?>

/* install config/sidebars/bio.conf */
cache = yes

== About me ==
# Common rules for all options below (unless mentioned):
# * option has 3 props: icon, label, value; each option belongs to a group
# * label is retrieved from blog lang.conf by key "bio GROUP: OPT" or, if none, "bio OPT"
# * icon is autodetected in several places in static/bio/ folder in this order:
#   1/2. For 'my sex/country' - OPTNAME-OPTVAL.* or, if none, OPTVAL.*
#   3. GROUP-OPT.*
#   4. OPT.*
#   5. GROUP.*
#   For example, option 'char icq' is of 'chat' group and 'icq' name and icon for it
#   is looked up at these paths: static/bio/char-icq.*, .../icq.*, .../group.*.
# * empty value isn't shown if there's no associated icon

# set of 'png', 'gif' or none; encodes icons as base64 data URI that don't require loading.
# if value contains a number it's the max file size to encode (base64 is 33% larger).
data uri icons = png gif 3072

### CONTACT
# These options are newline-separated lists containing page URL (must contain ':'
# or '@' and no spaces) and/or link caption.

contact email =
contact forum =

projects www = {
}

chat icq =
chat skype =
chat irc =
chat jabber =

social facebook =
social twitter =


### MY INFO

my name = Living Soul
my sex = +Alien
my short = Passing by your uverse...

# flag icon is looked up as static/bio-FLAG.* where FLAG is first 2 chars of the
# country name (this value) in lower case.
my country = Russia
# format: [+-] NUM[[,.]fract] - e.g. "-3,5" is GMT-3.5.
my gmt = +4
# any string recognized by strtotime(), e.g. "2012/02/23" or "1 Jan 2011".
my birthday =
my interests =


### PHOTOS
# One photo per line; line format: "[?] image/file.jpg [link] [Photo title]", where
# 'image file' is relative to static/ (if extension is omitted it's autodetected) and
# 'link' must begin with either '/' (relative to site URL) or contain '://' (absolute).
# If 'link' is '-' (e.g. "pic.jpg - Description") image is not attached any link
# (by default if 'link' part is not present it's set to the image URL itself).
# Leading '?' enables random selection. If a line is just '--' a line break is inserted.

# Example: 3 photos: portrait and home and one of family or work pictures in between,
#          plus a line break before home. Indentation is optional.
#photos = {
#  portrait.jpg
#  ? family http://myfamily.blog.org Meet my family
#  ? work.jpg My workplace
#  --
#  home.jpg http://buildingcompany.net
#}

photos =


### FAVOURITES

fav movie =
fav band =
fav artist =
fav book =
fav writer =
fav game =
#fav Custom = Any other "fav ..." can be added.


### BIO TEXT

# if this is present bio is specified in raw HTML:
#== bio html ==
# wiki text follows until the end of the file; no options or comments are recognized.
== bio ==
//Hello, Earthlings!//

/* install base64:static/bio/alien.png */
iVBORw0KGgoAAAANSUhEUgAAABIAAAARCAYAAADQWvz5AAAD0klEQVR4XnWQe0yVBRiHn+9y+DiH
4zkiB5AD4sFQFERn4BgjZZZImOGwzbyk02YwbDO0y2pupE2WE4uCZC2XM1vN1FxaqFtTocFsuBY6
MrFAuXSM6/kO5/IdOLfO2NiKrWd7/3i33/PufV/+RVKcyXIxYXbiNSABAEgEsoClQDIgAMpsY+yZ
uXOszUD2tCwyDVRUr6st25W3txg4Eq+z/phneaZrg21bR2na9o6nEp69n6yk/Qx8ULKkbEtd2anC
KEk5MC0LTAO5ScaU7zZkbk7WB0yUFDzHwuWpzIo1gCDgHdfovfeYKy1XcTHGje4mb9dI5xbg+5kb
zY2XU4xFi0p5o+o1ctYvonewh5NnTtL4eSOdD+6yeHUK+/ZXULpiM0myTQFSZp6WkxtXePbYC5+a
V67NAinMF/Xn2HFoG5cGznPTeZXyut0cf+8EE+5JMlfZOLKlTiqZ92IjsHF6kBArx9fuLXgrJjUr
EYISbVdvc6HnK2rOHqXm6waqTx/nm9bz3FVucfnbK4S8ApYnjJQXVjE/ZlEtYBaBoiJb2ZrMjCWE
CaENT9La3cyed/fQaxqk/KMqXqndz7neJo5+VkOH2s5ov5NwEObZrGzK2LkQ2CnrULbm2woRokL4
fUEmXBpKokL6Siv19W+yO6GSfZX7WH0wm+2rCliWn824Oo5OLxOWAixPzSH2rmWjbI6as8xsMDPh
nySshZFEGVOkj4mWyFs6wcdvN9By/RfSCgeJNwnopGh06JjQJpmMOEaDEYs+KU2UBdkUCAbwaRqa
V0OURGzKAh7d9nCw/B0q64fJ2HSJ9w9V4v5zLgyJGIwxaJoWcXz4/X6iREURPQF3/6g6gsftwev1
4nSpkXVX0H35IXeuZfH6thaO7b+J+7etXGloJi+5AI/mxuvxTjmj6igO34hDdAUdN+/ZO3GMjuN2
uVGdKqpLZf2Cjfx9wUnNjp84vKONtrpO1iU+jz/oZ8wxhsfjwekY54+/uhiasP8qAqea7U0jD/se
MTbmwDXuwm630zvQR641n50ZL/NS+i7W2IoZGhqmv79/KhPJMtD3mBt9PwQCTJ4QAIBXV856+pO1
qaVYLLHo9dGIsoQkiciyDEAgEg8FQ4RC4anfqA4XrX3XuT52sQ7CBwSmgerF0U8ezo8rwjrHis4g
IihhRJ2AKIoE/EFCPgh5YVgdoX20hQ5P66kQwQogIPBfio3C7A/TlWWZ8/XpxOrj0OsMiIKAL+BD
1Rz0az088N0ZUENDB4EvgTD/gwJsEJFOGzDdMguW3yN1PwZzu4R8FtgOGJnBP9wijRl6jwcSAAAA
AElFTkSuQmCC

/* install base64:static/bio/en.png */
R0lGODlhEAALANUAAGNjtvr6+vb29fHx8fxGRvkQEP15eatjSuNjSjx6+TV0+f2Kd+np6dvb2PxU
VPx4YttjSvsrK5q7/PxlZrpjSvw6Oubm5e7u7sljSgR09Z1jSvT080iB+gBMtkF9+vofHwBpu/f3
9uLi3/syMtVjSqG+/C9y+Ozs7KLA/GNlwPyBbO3t6gNx5QArs/2XhpGRgKysn+z+/rS0qPR0XuXl
/P7KwcnJwf39Wzh3+f7+/fv/+vHx7wNv4df+/f3h3GNnxCH5BAAAAAAALAAAAAAQAAsAAAaMwJ/w
l0oBjqoHYgmB/HIoXSkgoQYCoawA9kNxOJ5EAmcyTByEiouUmnoEiYspMxhcTreNrR1OKOYgaBUj
EQsYAAEJAwonLCIddwwMFj0yABI4fzwgHS2DER8fCwciAQIbG3aRkxYNPi8qNWZoaRGgBbgqGg0B
MVqoqTsrNBYiM0sITU0kGBQUBwca0kEAOw==

/* install base64:static/bio/ru.png */
R0lGODlhEAALANUAAI2N+PLy/fQtLRgY8889aJyc/vz8/McnVvMWFjAw91VV/ePk7/pbW/xkZCor
9oOD9yIi9fr6+vf39/hQUPo9PXR0/t7e6vb29pWV/NJHcOwAAPdERPU7O/MAAEpK/cMcTeUAAD8/
9e/v+vM0NL4SRfENDQAA5kZG+0BA+jY29zs7+AAA/U9P/OAAAPg0NG9v/ezs9rMAAOjo8n199dxq
jPpERHsAAMoyX/gAALGx/lBP/fUhId0AAP7+/vX1/////yH5BAAAAAAALAAAAAAQAAsAAAaGQJ9Q
GCiKRDCYTLZY+H6/nrRnqBoiEYnE8pxar1nJZevJFc6YNGD9eMwAplVFodB5TihVKuGAQEJxcyx3
eXt9EAMqcS+DeHp8fgMDKSYxNBkZBAQ3NwcHHx8kJDc2OA01FBwuAgI7OwgIJSUCLaYMDBO5Gxsc
HCMjrDwdwxrFxSDILS08zEEAOw==